#!/bin/bash

###############################################################################
# Script to Install a MultiMaster LDAP Server.                                #
# Copyright (C) 2019 Thorsten Seeger                                          #
#                                                                             #
# Version: 0.18.4                                                             #
#                                                                             #
#    This program is free software: you can redistribute it and/or modify     #
#    it under the terms of the GNU General Public License as published by     #
#    the Free Software Foundation, either version 3 of the License, or        #
#    (at your option) any later version.                                      #
#                                                                             #
#    This program is distributed in the hope that it will be useful,          #
#    but WITHOUT ANY WARRANTY; without even the implied warranty of           #
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            #
#    GNU General Public License for more details.                             #
#                                                                             #
#    You should have received a copy of the GNU General Public License        #
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.    #
###############################################################################

# --------------------------------------------------------------------------- #
#  Disclaimer: Feel free to use this script at your own charge, I cannot be   #
#              held responsible for what YOU do on YOUR administered system.  #
# --------------------------------------------------------------------------- #

export LC_ALL=C.UTF-8
# Tell ncurses to use unicode values which correspond to the 
# VT100 line-drawing glyphs.
export NCURSES_NO_UTF8_ACS=1

# trace ERR through pipes
set -o pipefail
# trace ERR through 'time command' and other functions (-E)
set -o errtrace
# exit - undeclared variables (-u)
set -o nounset
# exit - on error (-e)
set -o errexit
# Locate and remember (hash) commands (-h)
set -o hashall
# Print a trace (-x)
#set -o xtrace
# Verbose (-v)
#set -o verbose

if [[ -z "${BASH_SOURCE[0]}" ]]
then
  printf '%b\n' "BASH_SOURCE[0] is empty!"
  printf '%b\n' "Please cd in the script directory"
  exit 2
fi

__EXECPATH="$(cd "$(dirname "${BASH_SOURCE[0]}")" && printf "${PWD}")"
declare _source_func_file="${__EXECPATH}/func/ldapx.func"
if [[ ! -e ${_source_func_file} ]]
then
  printf '%b\n' "\e[91m ERROR: ${_source_func_file} DON'T EXIST\e[0m"
  exit 2
fi
source ${_source_func_file}
unset _source_func_file

###############################       Main       ##############################
utils::main 1
###############################################################################

#utils.pause 'Press [Enter] key to continue...'

exit 0
###############################################################################